﻿using System;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;

public partial class DoDFragmentDetailsDelete : BasePage
{
    private DoDFragmentManager _manager = new DoDFragmentManager();
    protected readonly string DoDFragmentPage = "DoDFragment.aspx?patientId="; 
                                                
    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
        HiddenFieldLabID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentLabId"], false);
        HiddenFieldFragmentID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentId"], false);

        DOD_FRAGMENT fragment = _manager.GetDoDFragmentById(Helpers.GetIntFromString(HiddenFieldFragmentID.Value));
        fragment.SetAsChangeTrackingRoot();
        fragment.SetAsDeleteOnSubmit();

        _manager.Update(fragment);

        ResponseRedirect(DoDFragmentPage, GetValidStringValue(HiddenFieldPatientID.Value));
    }

    private string GetValidStringValue(string pCurrentQueue)
    {
        string currentQueue = string.Empty;
        if (pCurrentQueue != null)
        {
            if (Regex.IsMatch(pCurrentQueue, "^[a-zA-Z0-9]*$"))
            {
                currentQueue = pCurrentQueue;
            }
        }
        return currentQueue;
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    private void ResponseRedirect(string destination, string queryString)
    {
        string queryStringValue = string.Empty;
        if (queryString != null)
            queryStringValue = AntiXssEncoder.UrlEncode(queryString);

        string destinationUrl = string.Concat(destination, queryStringValue);
        string currentHost = Request.Url.Host;
        if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            Server.Transfer(destinationUrl);
    }
}